import { AccentFirstLetter, Avatar, classNames, EMAIL_HOST, Loader } from '@yandex-infracloud-ui/libs';
import { BellIcon, SlashBellIcon, CloseIcon } from 'design/icons';
import { Button } from 'lego-on-react';
import * as React from 'react';
import { useCallback } from 'react';

import { LegoCheckbox } from '../../shared/lego';

import styles from './EmailNotificationRow.module.css';

import { ILevel, IRow, isImplicitChecked, SEVERITY_LEVELS } from './models';

interface IProps {
   isLoading: boolean;
   readonly: boolean;
   row: IRow;

   onChange(row: IRow, level: ILevel): void;

   onRemove(row: IRow): void;
}

export const EmailNotificationRow = React.memo(({ readonly, row, isLoading, onChange, onRemove }: IProps) => {
   const login = row.email.replace(new RegExp(`${EMAIL_HOST}$`), '');

   // handlers
   const remove = useCallback(() => onRemove(row), [row, onRemove]);

   // render
   return (
      <tr key={row.email}>
         <td className={styles.userNameCell}>
            {isLoading ? <Loader inline={true} visible={!row.name} /> : <Avatar login={login} />}

            <AccentFirstLetter value={row.name || row.email} />
            <div className={styles.login}>{login}</div>
         </td>

         {SEVERITY_LEVELS.map(level => {
            const isChecked = isImplicitChecked(row.levels, level.level);

            return (
               <td key={level.id} className={styles.checkboxCell}>
                  {readonly ? (
                     isChecked ? (
                        <BellIcon className={classNames(styles.bell, styles.checked)} />
                     ) : (
                        <SlashBellIcon className={styles.bell} />
                     )
                  ) : (
                     <LegoCheckbox
                        theme={'normal'}
                        size={'n'}
                        name={level.title}
                        checked={isChecked || row.levels[level.id]}
                        onChange={() => onChange(row, level)}
                        disabled={isChecked || readonly}
                     />
                  )}
               </td>
            );
         })}

         {readonly ? null : (
            <td className={styles.buttonCell}>
               <Button theme={'clear'} size={'s'} cls={styles.removeButton} onClick={remove}>
                  <CloseIcon size={'lg'} />
               </Button>
            </td>
         )}
      </tr>
   );
});

EmailNotificationRow.displayName = 'EmailNotificationRow';
