import { json } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { SyntheticEvent, useState } from 'react';

import { NotificationRecipients } from '../../models';
import { outlineDecorator, toastsSupportDecorator } from '../../stories';
import { IStoryDefaults } from '../../stories/typings';
import { EmailNotifications } from './EmailNotifications';

export const Empty = ({ readonly }: { readonly: boolean }) => {
   const [value, setValue] = useState({} as NotificationRecipients);

   const onChange = (e: SyntheticEvent, v: NotificationRecipients) => setValue(v);

   return (
      <>
         <EmailNotifications readonly={readonly} value={value} onChange={onChange} />

         <pre>{json(value)}</pre>
      </>
   );
};

export const ReadonlyEmpty = () => <Empty readonly={true} />;

export const Filled = ({ readonly }: { readonly: boolean }) => {
   const [value, setValue] = useState({
      audit: ['khoden@yandex-team.ru'],
      bot: ['khoden@yandex-team.ru', 'mertas@yandex-team.ru'],
      info: ['unknown@yandex-team.ru', 'iperfilyev@yandex-team.ru'],
      warning: ['mertas@yandex-team.ru'],
   } as NotificationRecipients);

   const onChange = (e: SyntheticEvent, v: NotificationRecipients) => setValue(v);

   return (
      <>
         <EmailNotifications readonly={readonly} value={value} onChange={onChange} />

         <pre>{json(value)}</pre>
      </>
   );
};

export const ReadonlyFilled = () => <Filled readonly={true} />;

export default {
   decorators: [toastsSupportDecorator, outlineDecorator],
   title: 'rich_shared|EmailNotifications',
} as IStoryDefaults;
