import { IValueProps, LegoModal, ModalLayout } from '@yandex-infracloud-ui/libs';
import * as React from 'react';

import { NotificationRecipients } from '../../models';

import { EmailNotifications } from './EmailNotifications';

interface IProps extends IValueProps<NotificationRecipients> {
   onClose(): void;
}

export const EmailNotificationsModal = React.memo(({ onClose, value, onChange }: IProps) => {
   // TODO выкинуть LegoModal
   return (
      <LegoModal visible={true} onOutsideClick={onClose}>
         <ModalLayout title={'Edit email notifications'} okLabel={'Confirm'} onOk={onClose} onDismiss={onClose}>
            <EmailNotifications value={value} onChange={onChange} />
         </ModalLayout>
      </LegoModal>
   );
});
