import { NotificationSeverity } from '../../models';
import { isImplicitChecked, toggleLevel } from './models';

describe('EmailNotifications models', () => {
   describe('isImplicitChecked', () => {
      it('bot only', () => {
         expect(
            isImplicitChecked(
               { audit: false, bot: true, critical: false, error: false, info: false, warning: false },
               3, // error
            ),
         ).toBe(false);
      });

      it('error if audit', () => {
         expect(
            isImplicitChecked(
               { audit: true, bot: true, critical: false, error: false, info: false, warning: false },
               3, // error
            ),
         ).toBe(true);
      });

      it('critical if error', () => {
         expect(
            isImplicitChecked(
               { audit: false, bot: false, critical: false, error: true, info: false, warning: false },
               4, // critical
            ),
         ).toBe(true);
      });

      it('critical if critical', () => {
         expect(
            isImplicitChecked(
               { audit: false, bot: true, critical: true, error: false, info: false, warning: false },
               4, // critical
            ),
         ).toBe(false);
      });
   });

   describe('toggleLevel', () => {
      it('should work with bot', () => {
         expect(
            toggleLevel(
               { audit: false, bot: true, critical: false, error: true, info: false, warning: false },
               { title: 'BOT', id: NotificationSeverity.Bot },
            ),
         ).toEqual({ audit: false, bot: false, critical: false, error: true, info: false, warning: false });
      });

      it('should work with warning', () => {
         expect(
            toggleLevel(
               { audit: false, bot: true, critical: false, error: false, info: false, warning: true },
               { title: 'Warn', id: NotificationSeverity.Warning, level: 2 },
            ),
         ).toEqual({ audit: false, bot: true, critical: false, error: false, info: false, warning: false });

         expect(
            toggleLevel(
               { audit: false, bot: false, critical: false, error: true, info: false, warning: false },
               { title: 'Warn', id: NotificationSeverity.Warning, level: 2 },
            ),
         ).toEqual({ audit: false, bot: false, critical: false, error: false, info: false, warning: true });
      });
   });
});
