import { Loader } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';

import { IOperationLogItem } from '../../../models';

import { OperationLogLayout } from '../models';
import { OperationLogItem } from './OperationLogItem';
import styles from './OperationLogList.module.css';

interface IProps {
   expanded: Set<string>;
   isLoading: boolean;
   items: IOperationLogItem[];
   layout: OperationLogLayout;

   expand(id: string): void;
}

export const OperationLogList = React.memo((props: IProps) => {
   const [hoveredAuditLog, setHoveredAuditLog] = React.useState<string>();

   return (
      <>
         <table className={styles.table}>
            <thead>
               <tr>
                  <th>Target</th>
                  <th>Type</th>
                  <th>Date</th>
               </tr>
            </thead>
            <tbody>
               {props.items.map(li => (
                  <OperationLogItem
                     key={li.id}
                     layout={props.layout}
                     value={li}
                     expanded={props.expanded}
                     expand={props.expand}
                     hovered={hoveredAuditLog === li.audit_log_id}
                     onHover={setHoveredAuditLog}
                  />
               ))}
            </tbody>
         </table>

         <Loader cls={styles.loader} visible={props.isLoading} text={'Operation log loading'} />

         {props.items.length === 0 && !props.isLoading ? (
            <div className={styles.noData} data-e2e={'no-data'}>
               No data
            </div>
         ) : null}
      </>
   );
});

OperationLogList.displayName = 'OperationLogList';
