import { NullableDate, queryValueToSet, setToQueryValue } from '@yandex-infracloud-ui/libs-next';
import { dateToUrl, urlToDate } from '../AuditLog/dateInUrl';
import { LogLayout } from '../AuditLog';

export type OperationLogLayout = LogLayout;

export interface IOperationLogFilters {
   id: Set<string>;
   fqdn: string;
   from: NullableDate;
   project: Set<string>;
   to: NullableDate;
   type: Set<string>;
   audit_log_id: Set<string>;
}

export interface IOperationLogUrlParams {
   fqdn?: string;
   from?: string;
   id?: string;
   project?: string;
   to?: string;
   type?: string;
   audit_log_id?: string;
}

export function operationLogFiltersToUrlParams(filters: IOperationLogFilters): IOperationLogUrlParams {
   return {
      fqdn: filters.fqdn,
      from: filters.from ? dateToUrl(filters.from) : undefined,
      project: setToQueryValue(filters.project),
      to: filters.to ? dateToUrl(filters.to) : undefined,
      type: setToQueryValue(filters.type),
   };
}

export function urlParamsToOperationLogFilters(query: IOperationLogUrlParams): IOperationLogFilters {
   return {
      id: new Set<string>(),
      fqdn: query.fqdn || '',
      from: query.from ? urlToDate(query.from) : null,
      project: queryValueToSet(query.project),
      to: query.to ? urlToDate(query.to, true) : null,
      type: queryValueToSet(query.type),
      audit_log_id: queryValueToSet(query.audit_log_id),
   };
}

export function getDefaultOperationLogFilters(): IOperationLogFilters {
   return {
      id: new Set(),
      fqdn: '',
      from: null,
      project: new Set(),
      to: null,
      type: new Set(),
      audit_log_id: new Set(),
   };
}
