import { storiesOf } from '@storybook/react';
import { json } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { SyntheticEvent, useState } from 'react';
import { IProfileConfigItem } from './models';
import { ProfileConfigInput } from './ProfileConfigInput';

function RegularStory() {
   // hooks
   const [item] = useState<IProfileConfigItem | null>(null);
   const [value, setValue] = useState<string | null>(item ? item.id : null);

   // handlers
   const select = (e: SyntheticEvent | null, v: IProfileConfigItem | null) => {
      setValue(v ? v.id : null);
   };
   const update = (e: SyntheticEvent | null, v: string | null) => {
      setValue(v || null);
   };

   // render
   return (
      <>
         <ProfileConfigInput initialQuery={value || undefined} onSelect={select} onQueryUpdate={update} />

         <pre>{json(value)}</pre>
      </>
   );
}

storiesOf('rich_shared|ProfileConfigInput', module).add('regular', () => <RegularStory />);
