import { Suggest } from '@yandex-data-ui/common';
import { EMPTY_VALUE } from '@yandex-infracloud-ui/libs';
import React, { useCallback } from 'react';
import { SyntheticEvent } from 'react';

import { SuggestSelectItem } from 'shared';
import { IProfileConfigItem } from './models';
import { strategy } from './strategy';

interface IProps {
   autofocus?: boolean;
   clearOnSelect?: boolean;
   cls?: string;
   disabled?: boolean;
   initialQuery?: string;

   onSelect(e: SyntheticEvent | null, item: IProfileConfigItem | null): void;
   onQueryUpdate(e: SyntheticEvent | null, q: string): void;
}

export const ProfileConfigInput = React.memo((props: IProps) => {
   const { onQueryUpdate, onSelect, initialQuery, disabled } = props;

   const handleChange = useCallback(
      (v: string) => {
         onQueryUpdate(null, v || '');
      },
      [onQueryUpdate],
   );
   const handleClick = useCallback(
      (v: IProfileConfigItem) => {
         onSelect(null, v || null);
      },
      [onSelect],
   );

   const handleGetItems = useCallback(async (query): Promise<IProfileConfigItem[] | any> => {
      if (!query) return [];

      return strategy
         .load(query)
         .toPromise()
         .then(resp => resp.slice(0, 10));
   }, []);

   return props.disabled ? (
      <>{props.initialQuery || EMPTY_VALUE}</>
   ) : (
      <Suggest
         getItems={handleGetItems}
         text={initialQuery}
         getItemsOnMount={true}
         onUpdate={handleChange}
         onItemClick={handleClick}
         onInputEnterKeyDown={handleChange}
         applicableInputValue={true}
         placeholder={'Profile config'}
         renderItem={item => <SuggestSelectItem title={item.id} />}
         debounce={500}
         disabled={disabled}
         syncPopupOnResize={false}
      />
   );
});

ProfileConfigInput.displayName = 'ProfileConfigInput';
