import * as React from 'react';
import { IProfileConfigItem } from './models';

import styles from './ProfileConfigItem.module.css';

interface IProps {
   item: IProfileConfigItem;
}

export const ProfileConfigItem = React.memo(({ item }: IProps) => (
   <div>
      {item.title}
      {item.isSupported ? <span className={styles.note}>EaaS</span> : null}
   </div>
));

ProfileConfigItem.displayName = 'ProfileConfigItem';
