import { ISuggestStrategy, SuggestLayer } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { forkJoin, Observable } from 'rxjs';
import { map } from 'rxjs/operators';

import { dictApi } from '../../services';

import { IProfileConfigItem } from './models';
import { ProfileConfigItem } from './ProfileConfigItem';

class ProfileConfigStrategy implements ISuggestStrategy {
   public load(query: string): Observable<IProfileConfigItem[]> {
      return forkJoin(dictApi.getConstants(), dictApi.getDeployConfigs()).pipe(
         map(([constants, configs]) => {
            return configs.eine
               .filter(item => item.toLowerCase().startsWith(query.toLowerCase()))
               .map(
                  item =>
                     ({
                        id: item,
                        isSupported: constants.allowed_default_profiles.includes(item),
                        layer: 'profileConfig' as SuggestLayer,
                        title: item,
                        url: `https://eine.yandex-team.ru/profiles/${item}`,
                     } as IProfileConfigItem),
               );
         }),
      );
   }

   public renderItem(entity: IProfileConfigItem): JSX.Element {
      return <ProfileConfigItem item={entity} />;
   }

   public getQueryFromEntity(entity: IProfileConfigItem): string {
      return entity.id as string;
   }

   public getPlaceholder(): string {
      return 'Profile config';
   }
}

export const strategy: ISuggestStrategy = new ProfileConfigStrategy();
