import React from 'react';
import { host } from 'storybook-host';
import { IStoryDefaults } from '../../stories/typings';
import { OwnershipValue } from '../../models';
import { ProjectSelect } from './ProjectSelect';
import { reduxStoryDecorator, userSwitcherDecorator } from '../../stories';

const props = {
   disabled: false,
   label: 'Select project',
   name: 'select_project',
   onSelect: () => null,
   ownership: OwnershipValue.All,
   readonly: false,
   value: 'test',
};

export const allProjects = () => <ProjectSelect {...props} />;

export const myProjects = () => <ProjectSelect {...props} ownership={OwnershipValue.My} />;

export default {
   decorators: [reduxStoryDecorator, userSwitcherDecorator, host()],
   title: 'rich_shared|ProjectSelect',
} as IStoryDefaults;
