import React, { useCallback, useState } from 'react';
import { host } from 'storybook-host';

import { OwnershipValue } from '../../../models';
import { config } from '../../../services';
import { IStoryDefaults } from '../../../stories/typings';

import { OwnershipTumbler } from './OwnershipTumbler';

export const Regular = () => {
   const [value, setValue] = useState(config.ownershipDefault);

   const handleChangeDefault = useCallback(() => (config.ownershipDefault = value), [value]);

   return (
      <OwnershipTumbler
         value={value}
         onChange={setValue}
         projectCounts={{
            [OwnershipValue.All]: 777,
            [OwnershipValue.My]: 7,
         }}
         defaultOwnership={config.ownershipDefault}
         onChangeDefault={handleChangeDefault}
      />
   );
};

export default {
   decorators: [host({ width: '20rem' })],
   title: 'rich_shared|ProjectSelect2/OwnershipTumbler',
} as IStoryDefaults;
