import { IListOption } from '@yandex-infracloud-ui/libs';
import { OwnershipValue } from '../../../models';
import { getOwnershipVariants } from './OwnershipTumbler';

describe('ProjectSelect2|OwnershipTumbler', () => {
   describe('getOwnershipVariants', () => {
      it('should return All at first, if all is default', () => {
         expect(getOwnershipVariants(OwnershipValue.All)).toEqual([
            { value: OwnershipValue.All, name: 'All' },
            { value: OwnershipValue.My, name: 'My' },
         ] as IListOption[]);
      });

      it('should return My at first, if my is default', () => {
         expect(getOwnershipVariants(OwnershipValue.My)).toEqual([
            { value: OwnershipValue.My, name: 'My' },
            { value: OwnershipValue.All, name: 'All' },
         ] as IListOption[]);
      });
   });
});
