import React, { SyntheticEvent, useCallback, useState } from 'react';
import { OwnershipValue } from '../../../models';

import { AutomationFilterValue, ProjectFilters } from '../../../state/projects/models';
import { fullWidthOutlineDecorator } from '../../../stories';
import { IStoryDefaults } from '../../../stories/typings';

import { ProjectFiltersView } from './ProjectFiltersView';

const projectCounts = {
   [OwnershipValue.My]: 24,
   [OwnershipValue.All]: 275,
};

function RegularStory() {
   const [value, setValue] = useState<ProjectFilters>({
      automation: AutomationFilterValue.All,
      ownership: OwnershipValue.My,
      query: '#RTC',
   });

   const updateValue = useCallback((e: SyntheticEvent | null, v: ProjectFilters) => setValue(v), []);

   return (
      <>
         <ProjectFiltersView projectCounts={projectCounts} value={value} onChange={updateValue} />
         {/*<pre>{json(value)}</pre>*/}
      </>
   );
}

export const regular = () => <RegularStory />;

export default {
   decorators: [
      fullWidthOutlineDecorator,
      story => <div style={{ maxWidth: '29.6rem', '--page-padding': '4.6rem' } as any}>{story()}</div>,
   ],
   title: 'rich_shared|ProjectSelect2/components/ProjectFiltersView',
} as IStoryDefaults;
