import { action } from '@storybook/addon-actions';
import { boolean } from '@storybook/addon-knobs';
import { addHours } from 'date-fns';
import React from 'react';
import { fullWidthOutlineDecorator, routerDecorator } from '../../../stories';
import { IStoryDefaults } from '../../../stories/typings';

import { ProjectItemView } from './ProjectItemView';

const testProject = {
   dns_automation: { enabled: true },
   healing_automation: { enabled: true },
   id: 'test',
   name: 'Project name',
};

// tslint:disable-next-line:variable-name
const fsm_handbrake = { timeout_time: addHours(new Date(), 1).getTime() / 1000 };

export const unchecked = () => (
   <ProjectItemView item={testProject} selected={boolean('selected', false)} toggle={action('toggle')} />
);

export const checked = () => (
   <ProjectItemView item={testProject} selected={boolean('selected', true)} toggle={action('toggle')} />
);

export const dnsDisabled = () => (
   <ProjectItemView
      item={{ ...testProject, dns_automation: { enabled: false } }}
      selected={boolean('selected', true)}
      toggle={action('toggle')}
   />
);

export const healingDisabled = () => (
   <ProjectItemView
      item={{ ...testProject, healing_automation: { enabled: false } }}
      selected={boolean('selected', true)}
      toggle={action('toggle')}
   />
);

export const bothDisabled = () => (
   <ProjectItemView
      item={{ ...testProject, dns_automation: { enabled: false }, healing_automation: { enabled: false } }}
      selected={boolean('selected', true)}
      toggle={action('toggle')}
   />
);

export const fsmTurnedOn = () => (
   <ProjectItemView
      item={{ ...testProject, fsm_handbrake }}
      selected={boolean('selected', true)}
      toggle={action('toggle')}
   />
);

export const longWarning = () => (
   <ProjectItemView
      item={{
         ...testProject,
         dns_automation: { enabled: false },
         healing_automation: { enabled: false },
         fsm_handbrake,
      }}
      selected={boolean('selected', true)}
      toggle={action('toggle')}
   />
);

const longProjectName = 'Very long project name for testing elapsing Very long project name for testing elapsing';
export const longName = () => (
   <ProjectItemView
      item={{ ...testProject, name: longProjectName }}
      selected={boolean('selected', true)}
      toggle={action('toggle')}
   />
);

export default {
   decorators: [
      fullWidthOutlineDecorator,
      story => (
         <div
            style={
               {
                  '--left-margin': 'calc(var(--page-padding) - 19px)',
                  '--page-padding': '3rem',
                  maxWidth: 300,
               } as any
            }
         >
            {story()}
         </div>
      ),
      routerDecorator,
   ],
   title: 'rich_shared|ProjectSelect2/components/ProjectItemView',
} as IStoryDefaults;
