import { action } from '@storybook/addon-actions';
import React from 'react';
import { ProjectItem } from '../../../state/projects/models';
import { fullWidthOutlineDecorator, reduxStoryDecorator, routerDecorator } from '../../../stories';

import { IStoryDefaults } from '../../../stories/typings';
import { ProjectList } from './ProjectList';

const items: ProjectItem[] = [
   {
      dns_automation: { enabled: true },
      healing_automation: { enabled: false },
      id: 'a',
      name: 'Project name',
   },
   {
      dns_automation: { enabled: false },
      healing_automation: { enabled: true },
      id: 'b',
      name: 'B',
   },
   {
      dns_automation: { enabled: false },
      healing_automation: { enabled: false },
      id: 'c',
      name: 'Very long project name for testing elapsing Very long project name for testing elapsing',
   },
   {
      dns_automation: { enabled: true },
      healing_automation: { enabled: false },
      id: 'd',
      name: 'D',
   },
];

export const smallList = () => (
   <ProjectList
      isAllSelected={false}
      items={items}
      selected={{ 'a': true }}
      toggle={action('toggle')}
      toggleAll={action('toggleAll')}
   />
);

export default {
   decorators: [
      reduxStoryDecorator,
      fullWidthOutlineDecorator,
      story => <div style={{ maxWidth: 400, '--page-padding': '3rem' } as any}>{story()}</div>,
      routerDecorator,
   ],
   title: 'rich_shared|ProjectSelect2/components/ProjectList',
} as IStoryDefaults;
