import { action } from '@storybook/addon-actions';
import { IListOption } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { routerDecorator } from '../../../stories';
import { IStoryDefaults } from '../../../stories/typings';
import { ProjectListWithTagLayout } from './ProjectListWithTagLayout';

const items: IListOption[] = [
   { value: 'test', name: 'Testing' },
   { value: 'test-clone-tes', name: 'Test Clone' },
];

export const Readonly = () => <ProjectListWithTagLayout editable={false} items={items} />;

export const Editable = () => <ProjectListWithTagLayout editable={true} items={items} onRemove={action('onRemove')} />;

export default {
   decorators: [routerDecorator],
   title: 'rich_shared|ProjectSelect2/components/ProjectListWithTagLayout',
} as IStoryDefaults;
