import React from 'react';

import {
   fullWidthOutlineDecorator,
   reduxStoryDecorator,
   routerDecorator,
   userSwitcherDecorator,
} from '../../../stories';
import { IStoryDefaults } from '../../../stories/typings';

import { ProjectSelect2 } from './ProjectSelect2';

export const regular = () => <ProjectSelect2 />;

export default {
   decorators: [
      reduxStoryDecorator,
      fullWidthOutlineDecorator,
      story => <div style={{ maxWidth: 400, '--page-padding': '3rem' } as any}>{story()}</div>,
      routerDecorator,
      userSwitcherDecorator,
   ],
   title: 'rich_shared|ProjectSelect2/components/ProjectSelect2',
} as IStoryDefaults;
