import React from 'react';

import { Skeleton, SkeletonItem, SkeletonPreset } from '../../../shared';
import classes from './ProjectSelect2Skeleton.module.css';

const items: SkeletonItem[] = [
   { size: SkeletonPreset.Medium, space: SkeletonPreset.Medium, width: '20%' },

   { size: SkeletonPreset.Large, space: SkeletonPreset.Small, width: '100%' },
   { size: SkeletonPreset.Large, space: SkeletonPreset.Small, width: '100%' },
   { size: SkeletonPreset.Large, space: SkeletonPreset.Large, width: '100%' },

   { size: SkeletonPreset.Medium, space: SkeletonPreset.Medium, width: '62%' },

   // items will be pushed bellow
];

for (let i = 0; i < 10; i += 1) {
   items.push(
      { size: SkeletonPreset.Small, space: SkeletonPreset.Small, width: '100%' },
      { size: SkeletonPreset.Small, space: SkeletonPreset.Large, width: '62%' },
   );
}

export const ProjectSelect2Skeleton = React.memo(() => (
   <div className={classes.wrapper}>
      <Skeleton items={items} />
   </div>
));

ProjectSelect2Skeleton.displayName = 'ProjectSelect2Skeleton';
