import { action } from '@storybook/addon-actions';
import React from 'react';
import { ProjectItem } from '../../../state/projects/models';

import { IStoryDefaults } from '../../../stories/typings';

import { ProjectWarnings2 } from './ProjectWarnings2';

const dnsOffProject: ProjectItem = {
   dns_automation: { enabled: false },
   healing_automation: { enabled: true },
   id: 'dns_off',
   name: 'DNS off',
};

const projects: ProjectItem[] = [
   {
      dns_automation: { enabled: false },
      healing_automation: { enabled: false },
      id: 'p1',
      name: 'Project 1',
   },
   {
      dns_automation: { enabled: false },
      fsm_handbrake: { timeout_time: Date.now() / 1000 + 3600 },
      healing_automation: { enabled: false },
      id: 'p2',
      name: 'Project 2',
   },
   {
      dns_automation: { enabled: true },
      healing_automation: { enabled: false },
      id: 'p3',
      name: 'Project 3',
   },
   {
      dns_automation: { enabled: true },
      healing_automation: { enabled: false },
      id: 'p4',
      name: 'Project 4',
   },
];

export const noProjects = () => <ProjectWarnings2 projects={[]} onClick={action('onClick')} />;

export const singleProjectDns = () => <ProjectWarnings2 projects={[dnsOffProject]} onClick={action('onClick')} />;

export const severalProjects = () => <ProjectWarnings2 projects={projects} onClick={action('onClick')} />;

export default {
   title: 'rich_shared|ProjectSelect2/components/ProjectWarnings2',
} as IStoryDefaults;
