import React from 'react';
import { Route } from 'react-router';

import { Sidebar } from '../../../shared';
import { reduxStoryDecorator, routerDecorator } from '../../../stories';
import { IStoryDefaults } from '../../../stories/typings';
import { ProjectSelect2 } from './ProjectSelect2';
import { ProjectsHeader } from './ProjectsHeader';

export const regular = () => (
   <Sidebar content={<ProjectSelect2 />} isCollapsed={false}>
      <Route render={routeProps => <ProjectsHeader {...routeProps} />} />
   </Sidebar>
);

export default {
   decorators: [reduxStoryDecorator, routerDecorator],
   title: 'rich_shared|ProjectSelect2/components/ProjectsHeader',
} as IStoryDefaults;
