import { ArrowToggle } from '@yandex-data-ui/common';
import { FieldLayout, IFieldProps } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';

export function AdvancedField(props: IFieldProps<boolean>) {
   const onToggle = () => {
      props.onChange(null, !props.value);
   };

   const customLabel = (
      <span onClick={onToggle} style={{ cursor: 'pointer' }}>
         {props.config.label as string} <ArrowToggle direction={props.value ? 'top' : 'bottom'} />
      </span>
   );

   return <FieldLayout config={props.config} customLabel={customLabel} help={props.help} error={props.error} />;
}
