import { Switch } from '@yandex-data-ui/common';
import { FieldLayout, IFieldProps } from '@yandex-infracloud-ui/libs';
import * as React from 'react';

export function BooleanSwitcherField(props: IFieldProps<boolean>) {
   return (
      <FieldLayout config={props.config} help={props.help} error={props.error}>
         <Switch
            disabled={props.disabled || props.readonly}
            name={props.config.name}
            checked={props.value}
            onUpdate={v => props.onChange(null, v)}
            content={props.config.checkboxLabel!}
         />
      </FieldLayout>
   );
}
