import { boolean } from '@storybook/addon-knobs';
import { storiesOf } from '@storybook/react';
import { FormFieldType, FormLayout, IFormField, json } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { SyntheticEvent, useCallback, useEffect, useState } from 'react';

import { BotProjectSelectField } from './BotProjectSelectField';

interface IProps {
   delay: number;
   value: number | undefined;
}

const BotProjectSelectFieldStory = ({ value: initialValue, delay }: IProps) => {
   // hooks
   const [value, setValue] = useState<number | undefined>(delay === 0 ? initialValue : undefined);

   useEffect(() => {
      let timer: number;
      if (delay > 0) {
         timer = window.setTimeout(() => setValue(initialValue), delay);
      }

      return () => window.clearTimeout(timer);
   }, [delay, initialValue]);

   // handlers
   const change = (e: SyntheticEvent | null, v: number) => setValue(v);

   // render
   return (
      <>
         <BotProjectSelectField
            config={
               {
                  component: BotProjectSelectField,
                  label: 'ABC service',
                  name: 'bot_project_id',
                  placeholder: 'Enter ABC service',
                  type: FormFieldType.Custom,
               } as IFormField<any>
            }
            disabled={boolean('disabled', false)}
            readonly={boolean('readonly', false)}
            value={value!}
            onChange={change}
         />
         <pre>{json(value)}</pre>
      </>
   );
};

const fields: IFormField<any>[] = [
   {
      component: BotProjectSelectField,
      label: 'ABC service',
      name: 'x',
      type: FormFieldType.Custom,
   },
];

const initialValue2 = { x: 100009170 };

type Value = typeof initialValue2;

function AbcServiceSelectFieldFormStory() {
   const [value, setValue] = useState(initialValue2);

   const update = useCallback((e: SyntheticEvent | null, v: Value) => setValue(v), []);

   return <FormLayout onChange={update} fields={fields} value={value} />;
}

storiesOf('rich_shared|form_fields/AbcServiceSelect', module)
   .add('empty', () => <BotProjectSelectFieldStory value={undefined} delay={0} />)
   .add('delayed', () => <BotProjectSelectFieldStory value={100000601} delay={2000} />)
   .add('with value', () => <BotProjectSelectFieldStory value={100000601} delay={0} />)
   .add('in form', () => <AbcServiceSelectFieldFormStory />);
