import { classNames, FieldLayout, IFieldProps, styleHelpers } from '@yandex-infracloud-ui/libs';
import { EMPTY_VALUE } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';
import { SyntheticEvent, useCallback, useEffect, useState } from 'react';
import { EXTERNAL_LINKS, IBotProject } from '../../models';

import { botProjectApi } from '../BotProjectInput/botProjectApi';
import { BotProjectInput } from '../BotProjectInput/BotProjectInput';
import classes from './fields.module.css';

interface IProps extends IFieldProps<number> {
   onChange(e: SyntheticEvent | null, v: number | string | null): void;
}

export const BotProjectSelectField = React.memo((props: IProps) => {
   // hooks
   const [service, setService] = useState<IBotProject | null>(null);

   // effects
   useEffect(() => {
      // -1 - BOT проект не найден
      if (!props.value || props.value === -1) {
         setService(null);

         return;
      }

      botProjectApi.getABCServiceByBotProject(Number(props.value)).subscribe(setService, () => undefined);
   }, [props.value]);

   // handlers
   const onSelect = useCallback(
      (e: SyntheticEvent, projectId: number | string | null) => props.onChange(e, projectId ?? null),
      [props],
   );

   // render
   return (
      <FieldLayout config={props.config} error={props.error}>
         {props.disabled || props.readonly ? (
            <>{props.value || EMPTY_VALUE}</>
         ) : (
            <BotProjectInput
               initialQuery={String(props.value ?? '')}
               cls={classNames({ [classes.error]: Boolean(props.error) })}
               name={props.config.name}
               onSelect={onSelect}
               disabled={props.disabled}
            />
         )}
         <div style={{ display: 'block', marginTop: '0.5em' }}>
            {service ? (
               <a
                  href={EXTERNAL_LINKS.abc(String(service.planner_id))}
                  className={styleHelpers.externalLink}
                  target={'_blank'}
                  rel={'noopener noreferrer'}
               >
                  {service.en_description}
               </a>
            ) : null}
         </div>
      </FieldLayout>
   );
});

BotProjectSelectField.displayName = 'BotProjectSelectField';
