import { FieldLayout, IFieldProps } from '@yandex-infracloud-ui/libs';
import * as React from 'react';

import { IDeployConfig } from '../../models';
import { DeployConfigSelect } from '../../shared/DeployConfigSelect/DeployConfigSelect';

export function DeployConfigField(props: IFieldProps<IDeployConfig>) {
   return (
      <FieldLayout config={props.config} help={props.help} error={props.error}>
         <DeployConfigSelect
            name={props.config.name}
            initialQuery={props.value ? props.value.config : ''}
            onSelect={props.onChange}
            disabled={props.disabled || props.readonly}
         />
      </FieldLayout>
   );
}
