import { EMPTY_VALUE, FieldLayout, IFieldProps } from '@yandex-infracloud-ui/libs';
import { YCSelect } from '@yandex-data-ui/common';
import * as React from 'react';
import { useCallback } from 'react';

import { useConstants } from '../../shared';
import classes from './DeployConfigPolicyField.module.css';

export const DeployConfigPolicyField = React.memo((props: IFieldProps<any>) => {
   const { constants } = useConstants();
   const policies = constants?.deploy_config_policies ?? []; // eslint-disable-line react-hooks/exhaustive-deps

   const items = React.useMemo(() => policies.map(({ name }) => ({ title: name, value: name })), [policies]);

   // handlers
   const onChange = props.onChange;

   const handlePolicyChange = useCallback((v: string) => onChange(null, v), [onChange]);

   return (
      <FieldLayout config={props.config} help={props.help} error={props.error}>
         {props.readonly ? (
            props.value || EMPTY_VALUE
         ) : (
            <>
               <YCSelect
                  className={classes.select}
                  onUpdate={handlePolicyChange}
                  type={'single'}
                  size={'s'}
                  items={items}
                  value={props.value}
                  placeholder={''}
                  showSearch={false}
                  stretched={false}
               />
            </>
         )}

         <details className={classes.descriptions}>
            <summary>Show detailed description</summary>

            <dl>
               {policies.map(p => (
                  <React.Fragment key={p.name}>
                     <dt>{p.name}</dt>
                     <dd>{p.description}</dd>
                  </React.Fragment>
               ))}
            </dl>
         </details>
      </FieldLayout>
   );
});

DeployConfigPolicyField.displayName = 'DeployConfigPolicyField';
