import { FieldLayout, IFieldProps, minMax, plural } from '@yandex-infracloud-ui/libs';
import { TextInput } from 'lego-on-react';
import * as React from 'react';

import styles from './DurationField.module.css';

export const DurationField = React.memo((props: IFieldProps<number>) => {
   // handlers
   const updateValue = (v: string) => props.onChange(null, minMax(parseInt(v, 10), 0, 1e9));

   // render
   return (
      <FieldLayout config={props.config} help={props.help} error={props.error}>
         <div className={styles.wrapper}>
            <TextInput
               type={'number'}
               theme={'normal'}
               size={'s'}
               cls={styles.control}
               text={props.value}
               onChange={updateValue}
            />
            {plural(props.value, 'second', 'seconds')}
         </div>
      </FieldLayout>
   );
});

DurationField.displayName = 'DurationField';
