import { FieldLayout, IFieldProps } from '@yandex-infracloud-ui/libs';
import { Button, Icon } from 'lego-on-react';
import * as React from 'react';
import { SyntheticEvent, useState } from 'react';

import editSvg from '../../design/icons/pencil.svg';
import { IProjectSubscribers, NotificationRecipients } from '../../models';
import { OwnersList } from '../../shared';
import { EmailNotificationsModal } from '../EmailNotifications/EmailNotificationsModal';
import { removeRecipients } from '../EmailNotifications/models';

import styles from './EmailNotificationsField.module.css';

export const EmailNotificationsField = React.memo(
   ({ config, help, error, readonly, disabled, value, onChange }: IFieldProps<IProjectSubscribers>) => {
      // hooks
      const [opened, setOpened] = useState(false);

      // Все получатели из всех категорий (просто для отображения)
      const allRecipients = Object.keys(value.recipients).reduce((acc, type) => {
         for (const email of value.recipients[type] as string[]) {
            acc.add(email);
         }

         return acc;
      }, new Set<string>());

      // handlers
      const openEditor = () => setOpened(true);

      const closeEditor = () => setOpened(false);

      const changeFromModal = (e: SyntheticEvent, recipients: NotificationRecipients) => onChange(e, { recipients });

      const changeFromUserList = (e: SyntheticEvent, emails: Set<string>) => {
         const emailsToDelete = new Set(allRecipients);
         emails.forEach(email => emailsToDelete.delete(email));

         changeFromModal(e, removeRecipients(value.recipients, emailsToDelete));
      };

      // render
      const editable = !readonly && !disabled;
      const label = (
         <>
            {config.label}
            {editable ? (
               <Button
                  theme={'clear'}
                  size={'s'}
                  cls={styles.editButton}
                  icon={<Icon url={editSvg} />}
                  onClick={openEditor}
               />
            ) : null}
         </>
      );

      return (
         <FieldLayout config={config} help={help} error={error} customLabel={label}>
            {/* По-хорошему можно было использовать UserList напрямую, но кажется, можно обойтись */}
            <OwnersList editable={editable} value={allRecipients} onChange={changeFromUserList} />

            {allRecipients.size === 0 ? <div className={styles.placeholder}>No subscribers</div> : null}

            {opened ? (
               <EmailNotificationsModal value={value.recipients} onChange={changeFromModal} onClose={closeEditor} />
            ) : null}
         </FieldLayout>
      );
   },
);

EmailNotificationsField.displayName = 'EmailNotificationsField';
