import { RadioButton } from '@yandex-data-ui/common';
import { FieldLayout, IFieldProps } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';

export function EnumField(props: IFieldProps<string>) {
   return (
      <FieldLayout config={props.config} help={props.help} error={props.error}>
         <RadioButton
            name={props.config.name}
            disabled={props.disabled || props.readonly}
            value={props.value}
            onUpdate={v => props.onChange(null, v)}
            options={props.config.options?.map(({ value, title }) => ({ value, content: title }))}
         />
      </FieldLayout>
   );
}
