import { EMPTY_VALUE, FieldLayout, IFieldProps } from '@yandex-infracloud-ui/libs';
import { YCSelect } from '@yandex-data-ui/common';
import * as React from 'react';

import classes from './EnumSelectField.module.css';

export const EnumSelectField = React.memo(
   ({ config, help, error, disabled, readonly, value, onChange }: IFieldProps<string>) => {
      // handlers
      const updateValue = (v: string) => {
         onChange(null, v);
      };

      // render
      return (
         <FieldLayout config={config} help={help} error={error}>
            {disabled || readonly ? (
               <>{value || EMPTY_VALUE}</>
            ) : (
               <YCSelect
                  className={classes.select}
                  onUpdate={updateValue}
                  type={'single'}
                  size={'s'}
                  items={config.options}
                  value={value}
                  placeholder={config.placeholder}
                  showSearch={false}
                  stretched={false}
               />
            )}
         </FieldLayout>
      );
   },
);

EnumSelectField.displayName = 'EnumSelectField';
