import { FieldLayout, IFieldProps } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { SyntheticEvent, useCallback } from 'react';
import { IHbfProject } from '../../models';

import { HbfProjectInput } from '../../shared';

const defaultConfig = {
   'readonly': false,
};

function addZero(id: string): string {
   return id.startsWith('0x') ? id : `0x${id}`;
}

export type HbfProjectConfig = typeof defaultConfig;

export const HbfProjectField = React.memo(
   ({ readonly, disabled, help, config, error, value, onChange }: IFieldProps<string>) => {
      // handlers
      const updateValue = useCallback(
         (e: SyntheticEvent | null, item: IHbfProject | null) => onChange(null, item ? addZero(item.id) : ''),
         [onChange],
      );

      const updateQuery = useCallback((e: SyntheticEvent | null, q: string) => onChange(null, q), [onChange]);

      const subConfig: HbfProjectConfig = Object.assign(defaultConfig, config.subConfig);

      const isDisabled = readonly || disabled || subConfig.readonly;

      // render
      return (
         <FieldLayout config={config} help={help} error={error}>
            <HbfProjectInput
               name={config.name}
               initialQuery={value}
               disabled={isDisabled}
               onSelect={updateValue}
               onQueryUpdate={updateQuery}
            />
         </FieldLayout>
      );
   },
);
