import { EMPTY_VALUE, FieldLayout, IFieldProps, toasts, useObservableValue } from '@yandex-infracloud-ui/libs';
import { Select } from 'lego-on-react';
import * as React from 'react';
import { useCallback } from 'react';
import { map } from 'rxjs/operators';
import { Link } from 'react-router-dom';

import { IMaintenancePlot, ROUTE_LINKS } from '../../models';
import { maintenancePlotsApi } from '../../services';

export const MaintenancePlotSelectField = React.memo(
   ({ readonly, disabled, config, help, error, value, onChange }: IFieldProps<string>) => {
      // hooks
      const plots = useObservableValue(
         maintenancePlotsApi.getList().pipe(map(resp => resp.result)),
         toasts.handleApiError('Maintenance plots loading'),
         [],
      );

      // handlers
      const updateValue = useCallback((v: string | string[]) => onChange(null, v[0]), [onChange]);

      // render
      return (
         <FieldLayout config={config} help={help} error={error}>
            {readonly ? (
               getReadonlyValue(plots, value)
            ) : (
               // TODO заменить Select на Dropdown из ui-components
               <div data-e2e={'MaintenancePlotSelectField:' + config.name}>
                  <Select
                     theme={'normal'}
                     type={'radio'}
                     size={'s'}
                     item-icon-hidden={true}
                     placeholder={'Select maintenance plot'}
                     val={value}
                     onChange={updateValue}
                     disabled={disabled}
                  >
                     {(plots || []).map(p => (
                        <Select.Item key={p.id} val={p.id}>
                           {p.meta_info.name}
                        </Select.Item>
                     ))}
                  </Select>
               </div>
            )}
         </FieldLayout>
      );
   },
);

MaintenancePlotSelectField.displayName = 'MaintenancePlotSelectField';

function getReadonlyValue(plots: IMaintenancePlot[] | null, value: string) {
   if (!value || !plots) {
      return EMPTY_VALUE;
   }

   const plot = plots.find(p => p.id === value);
   if (!plot) {
      return <Link to={ROUTE_LINKS.maintenancePlot(value)}>{value}</Link>;
   }

   return <Link to={ROUTE_LINKS.maintenancePlot(value)}>{plot.meta_info.name}</Link>;
}
