import { storiesOf } from '@storybook/react';
import { FormFieldType, IFormField } from '@yandex-infracloud-ui/libs';
import { default as React, SyntheticEvent, useState } from 'react';
import { DefaultCmsTaskAction, DefaultOperationState, IMaintenanceProperties } from '../../models';
import { DevJson } from '../../shared';
import { MaintenancePropertiesField } from './MaintenancePropertiesField';

const config: IFormField<any> = {
   label: 'Title for the field',
   name: '_fields',
   type: FormFieldType.String,
};

function RegularStory() {
   // hooks
   const [value, setValue] = useState<IMaintenanceProperties>({
      _timeoutTime: null,
      cms_task_action: DefaultCmsTaskAction,
      operation_state: DefaultOperationState,
      power_off: false,
      ticket_key: '',
      timeout_status: 'ready',
      timeout_time: null,
   });

   // handlers
   const update = (e: SyntheticEvent | null, v: IMaintenanceProperties) => setValue(v);

   // render
   return (
      <div style={{ marginLeft: '1rem', maxWidth: 500 }}>
         <MaintenancePropertiesField
            readonly={false}
            value={value}
            onChange={update}
            config={config}
            disabled={false}
         />

         <DevJson>{value}</DevJson>
      </div>
   );
}

storiesOf('rich_shared|form_fields/MaintenancePropertiesField', module).add('regular', () => <RegularStory />);
