import { FormFieldType, FormLayout, IFieldProps, IFormField, toTimestamp } from '@yandex-infracloud-ui/libs';
import React, { SyntheticEvent, useCallback, useMemo } from 'react';
import {
   cmsTaskActionField,
   operationStateField,
   ticketKeyField,
   timeoutStatusField,
   timeoutTimeField,
} from '../../actions/host_actions/actions/commonFields';

import { IMaintenanceProperties } from '../../models';
import styles from './MaintenancePropertiesField.module.css';

export interface IMaintenancePropertiesFieldSubConfig {
   skipFields: (keyof IMaintenanceProperties)[];
}

export const maintenancePropertiesFields: IFormField<IMaintenanceProperties>[] = [
   ticketKeyField,
   timeoutTimeField,
   timeoutStatusField,
   {
      checkboxLabel: 'Power off the host',
      name: 'power_off',
      type: FormFieldType.Boolean,
   },
   cmsTaskActionField,
   operationStateField,

   // Hidden
   { name: 'timeout_time', type: FormFieldType.Hidden },
];

export const MaintenancePropertiesField = React.memo(
   ({ disabled, onChange, readonly, value, config }: IFieldProps<IMaintenanceProperties>) => {
      const fields = useMemo(() => {
         const subConfig: IMaintenancePropertiesFieldSubConfig = config.subConfig || { skipFields: [] };
         const skipFields = new Set(subConfig.skipFields);

         return maintenancePropertiesFields.filter(f => !skipFields.has(f.name));
      }, [config.subConfig]);

      const update = useCallback(
         (e: SyntheticEvent | null, v: IMaintenanceProperties) => {
            v.timeout_time = v._timeoutTime instanceof Date ? toTimestamp(v._timeoutTime) : null;

            return onChange(e, v);
         },
         [onChange],
      );

      return (
         <div className={styles.wrapper}>
            <FormLayout fields={fields} value={value} onChange={update} readonly={disabled || readonly} />
         </div>
      );
   },
);

MaintenancePropertiesField.displayName = 'MaintenancePropertiesField';
