import { storiesOf } from '@storybook/react';
import { FormFieldType, IFormField, json } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { SyntheticEvent, useState } from 'react';
import { ProfileConfigField } from './ProfileConfigField';

const config: IFormField<any> = {
   label: 'Profile config',
   name: '_fields',
   type: FormFieldType.String,
};

function RegularStory() {
   // hooks
   const [value, setValue] = useState('common-firmware');

   // handlers
   const update = (e: SyntheticEvent | null, v: string) => {
      setValue(v);
   };

   // render
   return (
      <>
         <ProfileConfigField readonly={false} value={value} onChange={update} config={config} disabled={false} />
         <pre>{json(value)}</pre>
      </>
   );
}

storiesOf('rich_shared|form_fields/ProfileConfigField', module).add('regular', () => <RegularStory />);
