import { FieldLayout, IFieldProps } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { SyntheticEvent, useCallback } from 'react';

import { IProfileConfigItem, ProfileConfigInput } from '../ProfileConfigInput';

export const ProfileConfigField = React.memo(
   ({ config, help, readonly, disabled, value, error, onChange }: IFieldProps<string>) => {
      // handlers
      const onSelect = useCallback(
         (e: SyntheticEvent | null, v: IProfileConfigItem | null) => {
            onChange(e, v ? v.id : '');
         },
         [onChange],
      );
      const onQueryUpdate = useCallback(
         (e: SyntheticEvent | null, v: string | null) => {
            onChange(e, v || '');
         },
         [onChange],
      );

      // render
      return (
         <FieldLayout config={config} help={help} error={error}>
            <ProfileConfigInput
               initialQuery={value}
               onSelect={onSelect}
               onQueryUpdate={onQueryUpdate}
               disabled={disabled || readonly}
            />
         </FieldLayout>
      );
   },
);

ProfileConfigField.displayName = 'ProfileConfigField';
