import { classNames, CopyableText, EMPTY_VALUE, FieldLayout, IFieldProps } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';

import { TextInputWithCounter } from '../../shared';
import classes from './fields.module.css';

export const ProjectIdField = React.memo((props: IFieldProps<string>) => {
   const onChange = (value: string) => props.onChange(null, value);

   return (
      <FieldLayout config={props.config} help={props.help} error={props.error}>
         {props.readonly ? (
            props.value ? (
               <span>
                  {props.value} <CopyableText text={props.value} />
               </span>
            ) : (
               EMPTY_VALUE
            )
         ) : (
            <TextInputWithCounter
               text={props.value}
               cls={classNames({ [classes.error]: Boolean(props.error) })}
               name={props.config.name}
               placeholder={props.config.placeholder}
               disabled={props.disabled}
               onUpdate={onChange}
               maxLength={32}
            />
         )}
      </FieldLayout>
   );
});

ProjectIdField.displayName = 'ProjectIdField';
