import { boolean } from '@storybook/addon-knobs';
import { storiesOf } from '@storybook/react';
import { FormFieldType, IFormField, json } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { SyntheticEvent, useCallback, useState } from 'react';
import { createProjectOwners, ProjectOwners } from '../../models';
import { userSwitcherDecorator, reduxStoryDecorator } from '../../stories';
import { ProjectOwnersField } from './ProjectOwnersField';

const config: IFormField<any> = {
   label: 'Owners',
   name: '_fields',
   type: FormFieldType.String,
};

interface IProps {
   editable: boolean;
   initialValue: ProjectOwners;
}

function Story({ editable, initialValue }: IProps) {
   // hooks
   const [value, setValue] = useState(initialValue);

   // handlers
   const update = useCallback((e: SyntheticEvent | null, v: ProjectOwners) => setValue(v), []);

   // render
   return (
      <>
         <ProjectOwnersField
            context={{ id: 'test' }}
            readonly={boolean('readonly', !editable)}
            disabled={boolean('disabled', !editable)}
            config={config}
            value={value}
            onChange={update}
         />
      </>
   );
}

function ExternalChangeStory({ editable, initialValue }: IProps) {
   // hooks
   const [value, setValue] = useState(initialValue);

   // handlers
   const update = useCallback((e: SyntheticEvent | null, v: ProjectOwners) => setValue(v), []);

   // render
   return (
      <div style={{ display: 'flex' }}>
         <section style={{ flexGrow: 1 }}>
            <h3>Instance 1</h3>
            <ProjectOwnersField
               context={{ id: 'test' }}
               readonly={boolean('readonly', !editable)}
               disabled={boolean('disabled', !editable)}
               config={config}
               value={value}
               onChange={update}
            />
         </section>

         <section style={{ flexGrow: 1 }}>
            <h3>Instance 2</h3>
            <ProjectOwnersField
               context={{ id: 'test' }}
               readonly={boolean('readonly', !editable)}
               disabled={boolean('disabled', !editable)}
               config={config}
               value={value}
               onChange={update}
            />
         </section>

         <section style={{ flexGrow: 1 }}>
            <pre>{json(value)}</pre>
         </section>
      </div>
   );
}

storiesOf('rich_shared|form_fields/ProjectOwnersField', module)
   .addDecorator(userSwitcherDecorator)
   .addDecorator(reduxStoryDecorator)
   .add('all', () => (
      <Story
         initialValue={{
            actualOwners: new Set(['actual1', 'actual2']),
            requestedOwners: new Map([['requested1', { login: 'requested1', id: 0 }]]),
            revokingOwners: new Map([['revoking1', { login: 'revoking1', id: 0 }]]),
            toAdd: new Set(['toAdd1', 'toAdd2']),
            toRemove: new Set(['toRemove1', 'toRemove2']),
         }}
         editable={true}
      />
   ))
   .add('empty', () => <Story initialValue={createProjectOwners()} editable={false} />)
   .add('only owners', () => (
      <Story
         initialValue={createProjectOwners({
            actualOwners: new Set(['actual1', 'actual2']),
         })}
         editable={true}
      />
   ))
   .add('with requested', () => (
      <Story
         initialValue={createProjectOwners({
            actualOwners: new Set(['actual1', 'actual2']),
            requestedOwners: new Map([['requested1', { login: 'requested1', id: 0 }]]),
         })}
         editable={true}
      />
   ))
   .add('external changes', () => (
      <ExternalChangeStory
         initialValue={createProjectOwners({
            actualOwners: new Set(['actual1', 'actual2']),
         })}
         editable={true}
      />
   ));
