import { FormFieldType, FormLayout, IFormField, Loader, useDismounted } from '@yandex-infracloud-ui/libs';
import React, { SyntheticEvent, useCallback, useEffect, useState } from 'react';
import { takeUntil } from 'rxjs/operators';
import { host } from 'storybook-host';
import { IProject } from '../../../models';
import { projectApi } from '../../../services';
import { ProjectIdContext } from '../../../shared';
import { toastsSupportDecorator } from '../../../stories';
import { IStoryDefaults } from '../../../stories/typings';

import { ProjectRolesEditorField } from './ProjectRolesEditorField';

const fields: IFormField<IProject>[] = [
   {
      name: 'roles',
      component: ProjectRolesEditorField,
      type: FormFieldType.Custom,
   },
];

export const Regular = () => {
   const [value, setValue] = useState<IProject>();
   const dismounted = useDismounted();

   const handleChange = useCallback((e: SyntheticEvent, v: IProject) => setValue(v), []);

   useEffect(() => {
      projectApi.getById('test', ['id', 'name', 'roles']).pipe(takeUntil(dismounted)).subscribe(setValue);
   }, [dismounted]);

   if (!value) {
      return <Loader />;
   }

   return (
      <ProjectIdContext.Provider value={'test'}>
         <FormLayout onChange={handleChange} fields={fields} value={value} />
      </ProjectIdContext.Provider>
   );
};

export default {
   decorators: [host(), toastsSupportDecorator],
   title: 'rich_shared|form_fields/ProjectRolesEditorField',
} as IStoryDefaults;
