import { FieldLayout, fixedMemo, IFieldProps } from '@yandex-infracloud-ui/libs';
import React, { useCallback, useContext } from 'react';

import { HIDDEN_PROJECT_ROLES, ProjectRoles } from '../../../models';
import { ProjectIdContext } from '../../../shared';
import { RoleEditor } from './RoleEditor';

export const ProjectRolesEditorField = fixedMemo((props: IFieldProps<ProjectRoles | null>) => {
   const projectId = useContext(ProjectIdContext);
   if (!projectId) {
      throw new Error('You should define projectId ProjectIdContext');
   }

   const handleRoleChange = useCallback(
      (role: string, v: string[]) => {
         props.onChange(null, {
            ...props.value,
            [role]: v,
         });
      },
      [props],
   );

   return (
      <>
         {Object.keys(props.value ?? {})
            .filter(role => !HIDDEN_PROJECT_ROLES.has(role))
            .map(role => (
               <FieldLayout key={role} config={props.config} error={props.error} help={props.help} customLabel={role}>
                  <RoleEditor
                     disabled={props.disabled}
                     onChange={handleRoleChange}
                     projectId={projectId}
                     readonly={props.readonly}
                     role={role}
                     value={props.value?.[role] ?? []}
                  />
               </FieldLayout>
            ))}
      </>
   );
});

ProjectRolesEditorField.displayName = 'ProjectRolesEditorField';
