import { FieldLayout, IFieldProps } from '@yandex-infracloud-ui/libs-next';
import React, { SyntheticEvent, useCallback } from 'react';

import { OwnershipValue } from '../../models';
import { ProjectSelect } from '../ProjectSelect/ProjectSelect';

export const ProjectSelectField = React.memo(
   ({ disabled, error, config, help, readonly, value, onChange }: IFieldProps<string>) => {
      const onSelect = useCallback(
         (e: SyntheticEvent | null, v: Set<string>) => {
            onChange(e, v.size > 0 ? Array.from(v)[0] : '');
         },
         [onChange],
      );

      return (
         <FieldLayout config={config} help={help} error={error}>
            <ProjectSelect
               disabled={disabled}
               error={Boolean(error)}
               label={'Select project'}
               name={config.name}
               onSelect={onSelect}
               ownership={OwnershipValue.All}
               readonly={readonly}
               value={value}
            />
         </FieldLayout>
      );
   },
);

ProjectSelectField.displayName = 'ProjectSelectField';
