import { FieldLayout, IFieldProps } from '@yandex-infracloud-ui/libs';
import * as React from 'react';

import { IProject } from '../../models';
import { VLANsSelect } from '../../shared';

const defaultConfig = {
   readonly: false,
};

export type VLANsSelectFieldConfig = typeof defaultConfig;

export const VLANsSelectField2 = React.memo((props: IFieldProps<Set<number>>) => {
   const ownedVlans = (props.formValue as IProject).owned_vlans!;
   const subConfig: VLANsSelectFieldConfig = Object.assign(defaultConfig, props.config.subConfig);

   const readonly = props.readonly || props.disabled || subConfig.readonly;

   return (
      <FieldLayout config={props.config} help={props.help} error={props.error}>
         <VLANsSelect items={ownedVlans} readonly={readonly} value={props.value} onChange={props.onChange} />
      </FieldLayout>
   );
});

VLANsSelectField2.displayName = 'VLANsSelectField2';
