import { Suggest } from '@yandex-data-ui/common';
import {
   classNames,
   FieldLayout,
   IFieldProps,
   ISuggestBaseEntity,
   SuggestLayer,
   toggleSetItem,
} from '@yandex-infracloud-ui/libs-next';
import { getStrategy } from '@yandex-infracloud-ui/libs';
import { default as React, useCallback, useState } from 'react';

import { OwnersList } from '../../shared';

import styles from './newOwnersField.module.css';

export function newOwnersField(layer: SuggestLayer.People | SuggestLayer.Groups | SuggestLayer.PeopleOrGroups) {
   const strategy = getStrategy(layer);

   return (props: IFieldProps<Set<string>>) => {
      const [value, setValue] = useState('');

      const onSelect = useCallback(
         (item: ISuggestBaseEntity | null) => {
            if (item === null) {
               return;
            }

            const loginOrSlug = strategy.getQueryFromEntity(item);

            const id = item.layer === SuggestLayer.Groups ? `@${loginOrSlug}` : loginOrSlug;

            props.onChange(null, toggleSetItem(props.value, id));
         },
         [props],
      );

      const handleGetItems = useCallback(async (query): Promise<ISuggestBaseEntity[] | any> => {
         if (!query) return [];

         return strategy
            .load(query)
            .toPromise()
            .then((resp: ISuggestBaseEntity[]) => resp.slice(0, 10));
      }, []);

      return (
         <FieldLayout config={props.config} help={props.help} error={props.error}>
            {props.readonly ? null : (
               <Suggest
                  getItems={handleGetItems}
                  text={value}
                  getItemsOnMount={true}
                  onUpdate={setValue}
                  // onInputEnterKeyDown={onChange}
                  onItemClick={onSelect}
                  applicableInputValue={true}
                  placeholder={'Login or group'}
                  renderItem={item => strategy.renderItem(item as any, value)}
                  debounce={500}
                  syncPopupOnResize={false}
               />
            )}

            <div>
               <OwnersList
                  cls={classNames({
                     [styles.userListMarginTop]: !props.readonly,
                  })}
                  forceAvatars={true}
                  value={props.value}
                  editable={!props.disabled && !props.readonly}
                  onChange={props.onChange}
               />
            </div>
         </FieldLayout>
      );
   };
}
