import { FieldLayout, IFieldProps } from '@yandex-infracloud-ui/libs';
import * as React from 'react';

import {
   TagInput,
   // TagType,
   useProjectsTags,
} from '../../shared';

// TODO enum не компилится при экспорте во время тестов https://github.com/kulshekhar/ts-jest/issues/112
enum TagType {
   Deploy = 'deploy',
   Project = 'project',
}

const factory = (tagType: TagType, id: string) =>
   React.memo((props: IFieldProps<Set<string>>) => {
      const value = new Set(props.value);
      const getSuggestions = useProjectsTags(tagType);

      return (
         <FieldLayout config={props.config} help={props.help} error={props.error}>
            <TagInput
               getSuggestions={getSuggestions}
               disabled={props.disabled || props.readonly}
               id={id}
               name={props.config.name}
               value={value}
               onChange={props.onChange}
            />
         </FieldLayout>
      );
   });
export const ProjectTagsInputField = factory(TagType.Project, 'projectTag');
ProjectTagsInputField.displayName = 'ProjectTagsInputField';

export const DeployTagsInputField = factory(TagType.Deploy, 'deployTag');
DeployTagsInputField.displayName = 'DeployTagsInputField';
