import { action } from '@storybook/addon-actions';
import { ExtendedFieldConfig, json } from '@yandex-infracloud-ui/libs';
import { Form, Formik } from 'formik';
import React from 'react';
import { IStoryDefaults } from '../../stories/typings';
import { BotProjectField } from './BotProjectField';

const initialValue = {
   bot_project_id: null as number | null,
   existValue: 100009170 as number | null,
};

type Params = typeof initialValue;

function FieldStory(props: ExtendedFieldConfig<Params>) {
   return (
      <Formik initialValues={initialValue} onSubmit={action('onSubmit')}>
         {form => (
            <Form>
               <BotProjectField {...props} />

               <pre>{json(form)}</pre>
            </Form>
         )}
      </Formik>
   );
}

export const Regular = () => <FieldStory name={'bot_project_id'} label={'ABC service'} />;

export const Readonly = () => <FieldStory name={'existValue'} label={'ABC service'} readonly={true} />;

export default {
   title: 'rich_shared|form_fields2/ABCServiceField',
} as IStoryDefaults;
