import { classNames, ExtendedFieldConfig, FieldLayout2, useExtendedField } from '@yandex-infracloud-ui/libs-next';
import { FormikProps } from 'formik';
import React, { SyntheticEvent, useCallback, useMemo } from 'react';

import { AbcBotInput } from '../AbcBotInput/AbcBotInput';
import { IABCService } from '../AbcBotInput/models';
import classes from './fields.module.css';

const hardcodedHelp = (fieldName: string, form: FormikProps<any>) => {
   const v = form.values[fieldName];

   return v ? `ABC Service ID: ${v}` : null;
};

export const AbcServiceField = (props: ExtendedFieldConfig<any, number | null, {}>) => {
   const { disabled, field, onBlur, onChange, showError } = useExtendedField(props);
   const { name } = field;

   const help = useMemo(() => props.help || hardcodedHelp, [props.help]);

   const onSelect = useCallback((e: SyntheticEvent, item: IABCService | null) => onChange(item ? item.id : null), [
      onChange,
   ]);

   return (
      <FieldLayout2 help={help} {...props}>
         <AbcBotInput
            cls={classNames({ [classes.error]: showError })}
            name={name}
            onSelect={onSelect}
            onBlur={onBlur}
            clearOnSelect={false}
            disabled={disabled}
            {...props.controlProps}
         />
      </FieldLayout2>
   );
};
