import { Suggest } from '@yandex-data-ui/common';
import {
   classNames,
   ExtendedFieldConfig,
   FieldLayout2,
   useExtendedField,
   ISuggestBaseEntity,
   EMPTY_VALUE,
} from '@yandex-infracloud-ui/libs-next';
import React, { useCallback } from 'react';
import { strategy } from '../AbcBotInput/strategy';
import { SuggestSelectItem } from 'shared';

import classes from './fields.module.css';

export const AbcServiceSlugField = (props: ExtendedFieldConfig<any, string | null, {}>) => {
   const { disabled, field, onBlur, onChange, readonly, showError } = useExtendedField(props);

   const handleChange = useCallback(
      (v: string) => {
         onChange(v || null);
      },
      [onChange],
   );

   const handleClick = useCallback(
      (v: ISuggestBaseEntity) => {
         onChange(v.title || null);
      },
      [onChange],
   );
   const handleGetItems = useCallback(async (query): Promise<ISuggestBaseEntity[]> => {
      if (!query) return [];

      return strategy
         .load(query)
         .toPromise()
         .then((resp: ISuggestBaseEntity[]) => resp.slice(0, 10));
   }, []);

   return (
      <FieldLayout2 {...props}>
         {readonly ? (
            <div className={classes.readonlyValue}>{field.value || EMPTY_VALUE}</div>
         ) : (
            <Suggest
               getItems={handleGetItems}
               text={field.value || ''}
               onBlur={onBlur}
               className={classNames(classes.select, { [classes.error]: showError })}
               onUpdate={handleChange}
               onItemClick={handleClick}
               onInputEnterKeyDown={handleChange}
               applicableInputValue={true}
               disabled={disabled || readonly}
               placeholder={'ABC service slug'}
               renderItem={item => <SuggestSelectItem title={item.title} desc={`: ID (${item.id})`} />}
               debounce={500}
            />
         )}
      </FieldLayout2>
   );
};
