import { ArrowToggle } from '@yandex-data-ui/common';
import { ExtendedFieldConfig, useExtendedField, FieldLayout2 } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';

export function AdvancedField(props: ExtendedFieldConfig<any, boolean, {}>) {
   const { field, onChange } = useExtendedField(props);

   const onToggle = () => {
      onChange(!field.value);
   };

   const customLabel = (
      <span onClick={onToggle} style={{ cursor: 'pointer' }}>
         {props.label as string} <ArrowToggle direction={field.value ? 'top' : 'bottom'} />
      </span>
   );

   return <FieldLayout2 {...props} label={customLabel} />;
}

AdvancedField.displayName = 'AdvancedField';
