import { action } from '@storybook/addon-actions';
import { boolean, text } from '@storybook/addon-knobs';
import { ExtendedFieldConfig, json } from '@yandex-infracloud-ui/libs';
import { Form, Formik } from 'formik';
import React from 'react';
import { object, string } from 'yup';
import { IStoryDefaults } from '../../stories/typings';
import { AutomationPlotField } from './AutomationPlotField';

const initialValue = {
   id: 'qloud' as string | null,
   id2: '' as string | null,
};

type Params = typeof initialValue;

const validationSchema = object<Params>({
   id: string().nullable().required(),
   id2: string().nullable().required(),
});

function FieldStory(props: ExtendedFieldConfig<Params>) {
   return (
      <Formik
         initialValues={initialValue}
         onSubmit={action('onSubmit')}
         validationSchema={validationSchema}
         validateOnMount={true}
         initialTouched={{ id2: true }}
      >
         {form => (
            <Form>
               <AutomationPlotField {...props} />

               <pre>{json(form)}</pre>
            </Form>
         )}
      </Formik>
   );
}

export const Regular = () => <FieldStory name={'id'} label={'Regular'} placeholder={'Select automation plot'} />;

export const Disabled = () => <FieldStory name={'id'} label={'Disabled'} disabled={true} />;

export const Readonly = () => <FieldStory name={'id'} label={'Readonly'} readonly={true} />;

export const Empty = () => <FieldStory name={'id2'} label={'Readonly & Empty'} readonly={true} />;

export const WithError = () => <FieldStory name={'id2'} label={'With error'} validate={() => 'Is required'} />;

export const Playground = () => (
   <FieldStory
      name={'id'}
      label={text('label', 'label')}
      placeholder={text('placeholder', 'placeholder')}
      required={boolean('required', false)}
      disabled={boolean('disabled', false)}
      readonly={boolean('readonly', false)}
      help={text('help', 'help text')}
      hint={text('hint', 'short hint')}
      hidden={boolean('hidden', false)}
   />
);

export default {
   title: 'rich_shared|form_fields2/AutomationPlotField',
} as IStoryDefaults;
